%Position range:99 or 1-10
%When the position is set to 99, the MBC will track the point near half output power.
%When the position is set to 1-10, the MBC will track the 1st to 10th point in the range from zero to maximum output voltage.
function [status] = SetTrackingPosition(I_Position,Q_Position,P_Position) 
global s;
if(s.BytesAvailable ~= 0)
    fread(s,s.BytesAvailable);
end
byteID=119;
byteData=[I_Position Q_Position P_Position 0 0 0];
fwrite(s,[byteID byteData]);
dataRec = fread(s,9);
returnedByteID = dataRec(1,1);
if(returnedByteID ~= byteID)
    status = 102;
    disp('Unknown Error. Please try again')
    return;
end
status = dataRec(2,1);
if(status == 136)
    disp('Point Setting Failed. Controller Reset')
else
    disp('Point Setting Success. Controller Reset')
end